/*
 * Decompiled with CFR 0.152.
 */
package screenshotviewer;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.config.Configuration;

public class ScreenshotHandler {
    private final KeyBinding openScreenshotFolderKey;
    private final Configuration config;

    public ScreenshotHandler(Configuration config) {
        this.config = config;
        this.openScreenshotFolderKey = new KeyBinding("key.openScreenshotFolder", 207, "key.categories.screenshotmod");
        ClientRegistry.registerKeyBinding((KeyBinding)this.openScreenshotFolderKey);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void handleKeyInput(InputEvent.KeyInputEvent event) {
        if (this.openScreenshotFolderKey.func_151468_f()) {
            this.openScreenshotFolder();
        }
    }

    private void openScreenshotFolder() {
        try {
            File screenshotFolder = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
            if (!screenshotFolder.exists()) {
                screenshotFolder.mkdirs();
            }
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(screenshotFolder);
                System.out.println("Screenshot folder opened.");
            } else {
                System.out.println("Desktop API is not supported on this platform.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Error opening screenshot folder: " + e.getMessage());
        }
    }
}

